% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_calibration_functions.R
\name{sample.prior}
\alias{sample.prior}
\title{Sample from prior distributions of calibrated parameters}
\usage{
sample.prior(
  n_samp,
  v_param_names = c("r_DieMets", "r_RecurCDX2pos", "hr_RecurCDX2neg", "p_Mets"),
  v_lb = c(r_DieMets = 0.037, r_RecurCDX2pos = 0.001, hr_RecurCDX2neg = 1.58, p_Mets =
    0.9),
  v_ub = c(r_DieMets = -log(1 - (1 - 0.03))/60, r_RecurCDX2pos = 0.03, hr_RecurCDX2neg
    = 4.72, p_Mets = 0.99)
)
}
\arguments{
\item{n_samp}{Number of samples.}

\item{v_param_names}{Vector with parameter names.}

\item{v_lb}{Vector with upper bounds for each parameter.}

\item{v_ub}{Vector with lower bounds for each parameter.}
}
\value{
A matrix with 3 rows and \code{n_samp} rows. Each row corresponds to a
parameter set sampled from their prior distributions
}
\description{
\code{sample.prior} generates a sample of parameter sets from their prior
distribution.
}
\examples{
v_param_names  <- c("r_DieMets",
                    "r_RecurCDX2pos",
                    "hr_RecurCDX2neg",
                    "p_Mets")
n_param        <- length(v_param_names)
v_lb <- c(r_DieMets       = 0.037, 
          r_RecurCDX2pos  = 0.001,
          hr_RecurCDX2neg = 1.58, 
          p_Mets          = 0.9))  # lower bound
v_ub <- c(r_DieMets       = -log(1-(1-0.03))/60, 
          r_RecurCDX2pos  = 0.03,
          hr_RecurCDX2neg = 4.72, 
          p_Mets          = 0.99) # upper bound
sample.prior(2)
}
