% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05a_probabilistic_analysis_functions.R
\name{run_probsa}
\alias{run_probsa}
\title{Run a probabilistic sensitivity analysis (ProbSA) of the cost-effectiveness
model}
\usage{
run_probsa(df_psa_input, n_str = 2, parallel = FALSE)
}
\arguments{
\item{df_psa_input}{Data frame with ProbSA input dataset .}

\item{n_str}{Number of strategies}

\item{parallel}{Run ProbSA in parallel}
}
\value{
A list containing ProbSA cost and effectiveness outcomes for each strategy
}
\description{
\code{run_probsa} runs a probabilistic sensitivity analysis (ProbSA) and
calculates cost and effectiveness outcomes.
}
\examples{
df_psa_input <- generate_psa_params(load_all_params())
run_probsa(df_psa_input, parallel = FALSE)
}
