% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_calibration_functions.R
\name{log_prior}
\alias{log_prior}
\title{Evaluate log-prior of calibrated parameters}
\usage{
log_prior(
  v_params,
  v_param_names = c("r_DieMets", "r_RecurCDX2pos", "hr_RecurCDX2neg", "p_Mets"),
  v_lb = c(r_DieMets = 0.037, r_RecurCDX2pos = 0.001, hr_RecurCDX2neg = 1.58, p_Mets =
    0.9),
  v_ub = c(r_DieMets = -log(1 - (1 - 0.03))/60, r_RecurCDX2pos = 0.03, hr_RecurCDX2neg
    = 4.72, p_Mets = 0.99)
)
}
\arguments{
\item{v_params}{Vector (or matrix) of model parameters.}

\item{v_param_names}{Vector with parameter names.}

\item{v_lb}{Vector with upper bounds for each parameter.}

\item{v_ub}{Vector with lower bounds for each parameter.}
}
\value{
A scalar (or vector) with log-prior values.
}
\description{
\code{log_prior} computes a log-prior value for one (or multiple) parameter
set(s) based on their prior distributions.
}
\examples{
v_param_names  <- c("r_DieMets",
                    "r_RecurCDX2pos",
                    "hr_RecurCDX2neg",
                    "p_Mets")
n_param        <- length(v_param_names)
v_lb <- c(r_DieMets       = 0.037, 
          r_RecurCDX2pos  = 0.001,
          hr_RecurCDX2neg = 1.58, 
          p_Mets          = 0.9))  # lower bound
v_ub <- c(r_DieMets       = -log(1-(1-0.03))/60, 
          r_RecurCDX2pos  = 0.03,
          hr_RecurCDX2neg = 4.72, 
          p_Mets          = 0.99) # upper bound
log_prior(v_params = sample.prior(n_samp = 5))
}
