## A Simplified Model of the Cost-Effectiveness of Screening:               ##
## An Open-Source Teaching and Research Tool Coded in R                     ##

>August 2022

This is an intial read-me file to indicate how to use this model. The detail below does not assume
a working knowledge of the R programme. 

Within this directory you should find the following files:

ReadMe.txt (this document)
ExcelMaster.xls
ShinyApp_Plot.R
Simulation.R

You will also find the following directories:

InputFiles
OutputFiles

To run the R model you will need to install R or RStudio (https://cran.r-project.org/bin/windows/base/ 
or https://www.rstudio.com/products/rstudio/). You will also need to install the shiny package if you you wish
to use the shiny application. The follwing link provides an accessible guide to installing packages
(https://learningomics.wordpress.com/2013/01/31/how-to-install-packages-on-r-screenshots/). You may also
need to define the file path to where you have saved these files, the details of which are described below.

To inspect or edit the Simulation.R or ShinyApp_Plot.R files a plain text editor such as Notepad or Notepad++
can be a convenient tool.


***
### FILE DESCRIPTION ###

#### Simulation.R #### 

The Simulation.R file is the main file for running the model. This file contains the code for drawing input
values from the input files. It contains the model code for the structure of the model and its operation. The 
model outputs will be saved in the OutputFiles folder in whichever local directory you save the these files.

The Simulation.R file contains mark up and is structured in accordance with the models structure and operation.
Those with a knowledge of R and simulation modelling may wish to adjust the Simulation.R code. For those not 
familiar the model can be operated without a prior knowledge of R. The operation of the R model does not require
the installation of any R packages.


#### ShinyApp_Plot.R #### 

The ShinyApp_Plot.R file contains the code for running the Shiny app which provide a graphical user interface 
(GUI) within which to inspect the results of simulation model runs and to move between alternative parameter 
sets in order to inspect the effect of different parameters on model outcomes. The model Shiny app does not run
the model in real time but rather relies on previously generated output previously generated by the Simulation.R 
model.


#### ExcelMaster.xls #### 

The ExcelMaster.xls file is an Excel file that allows users define parameter input values and screening schedule 
details such as the frequency of screening and the age range without having to use R. This file is intended for 
use by those less familiar with R. The file used Visual Basic for Applications (VBA) Macros to navigate through 
the various portions of the file and to write the input to file for the R model to then use. The macros are used
by pressing the buttons within the Excel file. To ensure the macros can operate you may need to grant permission
when opening the Excel file.

Each tab within the ExcelMaster.xls file contains a brief description of the function of the sheet, including the
definition of parameters and saving of input files for execution.


***
### MODEL OPERATION ###

Download and save the four principal files and two folders to a location on your computer. The easiest way to do
this is to navigate to the URL (https://github.com/yishu-lin/Pedagogical-CEA-Model-of-Screening) and find the green
"Code" button and expand the dropdown menu. Users can select the "Download ZIP" option and download a complete zipped
version of the model, which they can then extract in a location of their preference. 

Users using R rather than R Studio will need to define the working directory within which they have saved. Users will
need to edit line 30 in the Simulation.R file to inculde their own relevant file path. For instance, if the model is 
saved in the following directory C:/Users/YourExampleFilePath/ then line 30 should read:

try(setwd("C:/Users/YourExampleFilePath/"), silent = TRUE)

Take care to ensure that all backslashes (\) copied from a file path are converted to forwardslashes (/) when setting
the directory.

Once the directory is set the model can be run in three different ways.

1. Open R expand "File", Select "Source R code...", navigate to the directory where Simulation.R is saved, select it and
press "Open" in the file explorer.

2. Edit the following file path to contain the relevant file and paste into R and press enter. Note the need for double 
backslashes:
source("C:\\Users\\YourExampleFilePath\\Pedagogical-CEA-Model-of-Screening-main\\Simulation.R")

3. Simply copy all the text within the Simulation.R file and paste in R.

The model will then run through all the strategies specified by the input files and save the relevant output in the Output
folder.
