% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txseq.R
\name{txseq_list}
\alias{txseq_list}
\title{A list of treatment sequences}
\usage{
txseq_list(..., start_line = c("first", "second"),
  mutation = c("unknown", "positive", "negative"))
}
\arguments{
\item{...}{Objects to form a list.}

\item{start_line}{The starting line of treatmnet that is being modeled. When
modeling second line treatment, the first line must be specified
in order to characterize a treatment history; however, note that disease 
transition model cannot currently be simulated for models starting at second
line because the evidence base is too limited.}

\item{mutation}{T790M mutation status. If the model starts at first line, then
this must be \code{"unknown"}; otherwise, if the model starts at second line,
then the mutation status must be specified as either \code{"positive"} or
\code{"negative"}, since it will be known.}
}
\value{
An object of class "txseq_list", which is a list of objects of class. 
\code{start_line} and \code{mutation} are stored as attributes.
}
\description{
Create a list of objects of class "txseq".
}
\examples{
txseq1 <- txseq(first = "erlotinib",
               second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
               second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab")) 
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2) 
class(txseqs)        
print(txseqs$seq1)
attributes(txseqs)
}
\seealso{
\code{\link{txseq}}
}
