% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarize_outcomes}
\alias{summarize_outcomes}
\title{Summarize model outcomes}
\usage{
summarize_outcomes(econmod, prod_costs = NULL, dr_qalys, dr_costs,
  wtp = 150000, digits_qalys = 2, digits_costs = 0, prob = 0.95,
  strategy_names = NULL)
}
\arguments{
\item{econmod}{An economic model of class "IndivCtstm" from the
\href{https://hesim-dev.github.io/hesim/}{hesim} package. 
 QALYs and costs must have been previously simulated (i.e., $qalys_ and 
 $costs_ cannot be NULL).}

\item{prod_costs}{An object of class "prod_costs" simulated using 
\code{\link{sim_prod_costs}}.}

\item{dr_qalys}{Discount rate for QALYs.}

\item{dr_costs}{Discount rate for costs.}

\item{wtp}{Willingness to pay for a QALY.}

\item{digits_qalys}{Number of digits to use to report QALYs.}

\item{digits_costs}{Number of digits to use to report costs.}

\item{prob}{A numeric scalar in the interval \code{(0,1)} giving the credible interval.
Default is 0.95 for a 95 percent credible interval.}

\item{strategy_names}{A character vector denoting names of treatment strategies.}
}
\value{
A \code{data.table} summarizing model outcomes.
}
\description{
Summarize clinical and economic outcomes from the simulation.
}
\seealso{
See the example in the \href{https://innovationvalueinitiative.github.io/IVI-NSCLC/articles/tutorial.html}{tutorial}.
}
