% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productivity-costs.R
\name{sim_prod_costs}
\alias{sim_prod_costs}
\title{Compute productivity costs}
\usage{
sim_prod_costs(econmod, patients, params = iviNSCLC::params_costs_prod,
  dr = 0.03, retirement_age = 65, method = "hca")
}
\arguments{
\item{econmod}{An economic model of class \code{"IndivCtstm"}. Disease progression
must have been previously simulated (i.e., \code{$disprog_} cannot be \code{NULL}.)}

\item{patients}{A \code{data.table} returned from \code{\link{create_patients}}.}

\item{params}{An object of the same format as \code{\link{params_costs_prod}}.}

\item{dr}{Discount rate.}

\item{retirement_age}{A numeric scalar denoting age at retirement.}

\item{method}{Method used to compute productivity losses. Currently only supports
the "human capital approach" (\code{hca}).}
}
\value{
An object of class "prod_costs", which is a \code{data.table} 
containing productivity costs. Columns are:
\describe{
\item{category}{The cost category.}
\item{dr}{The discount rate.}
\item{sample}{\code{sample} from \code{econmod$disprog_}}
\item{strategy_id}{\code{strategy_id} from \code{econmod$disprog_}}
\item{cost}{Productivity costs.}
}
}
\description{
Compute simulated productivity costs given simulated disease progression including 
costs from temporary disability, permanent disability, and premature mortality.
}
\seealso{
See the example in the \href{https://innovationvalueinitiative.github.io/IVI-NSCLC/articles/tutorial.html}{tutorial}.
}
