% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-setup.R
\name{model_structure}
\alias{model_structure}
\title{Model structure}
\usage{
model_structure(txseqs, n_states = c("four", "three"),
  dist = c("weibull", "gompertz", "fracpoly1", "fracpoly2"))
}
\arguments{
\item{txseqs}{A \code{\link{txseq_list}} object.}

\item{n_states}{Number of modeled health states.}

\item{dist}{Parametric distribution used to model health state transitions.
Options are \code{"weibull"} (Weibull), \code{"gompertz"} (gompertz),
\code{"fracpoly1"}(2nd order fractional polynomial with \eqn{p_1 = 0} and \eqn{p_2 = 0}),
and \code{"fracpoly2"}(2nd order fractional polynomial with \eqn{p_1 = 0} and \eqn{p_2 = 1}).}
}
\value{
A list containing the elements \code{txseqs}, \code{n_states} and
\code{dist}.
}
\description{
Define the structure of the oncology model.
}
\examples{
txseq1 <- txseq(first = "erlotinib",
                second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
               second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab")) 
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2)

# Model with 4 health states
struct <- model_structure(txseqs)
names(struct)
class(struct$txseqs)
struct$n_states
struct$dist

# Model with 3 health states
struct <- model_structure(txseqs, n_states = "three", dist = "weibull")
struct$n_states
}
