% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilmod.R
\name{create_utilmod}
\alias{create_utilmod}
\title{Create utility model}
\usage{
create_utilmod(n = 100, struct, patients, ae_probs,
  params_utility = iviNSCLC::params_utility, ae_duration = c("month",
  "progression"))
}
\arguments{
\item{n}{The number of random observations of the parameters to draw.}

\item{struct}{A \code{\link{model_structure}} object.}

\item{patients}{A data table returned from \code{\link{create_patients}}.}

\item{ae_probs}{An "ae_probs" object as returned by \code{\link{ae_probs}}.}

\item{params_utility}{Parameter estimates for health state utilities and
adverse event disutilities in the same format as \code{\link{params_utility}}.}

\item{ae_duration}{Duration of time over with disutility from adverse events 
should accrue. If \code{"month"}, then disutility accrues over the first
month of treatment; if \code{progression} then disutility accrues until
disease progression (i.e., over the entire duration of time spent in 
stable disease).}
}
\value{
An object of class "StateVals" from the 
\href{https://hesim-dev.github.io/hesim/}{hesim} package.
}
\description{
Create a model for health state utility given values of utility by
 health state, treatment, and time sampled from a probability distribution.
}
\examples{
# Treatment sequences
txseq1 <- txseq(first = "erlotinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2)

# Patient population
pats <- create_patients(n = 2)

## Model structure
struct <- model_structure(txseqs, dist = "weibull")

## Utility model
n_samples <- 2
ae_probs <- ae_probs(n = n_samples, struct = struct)
utilmod <- create_utilmod(n = n_samples, struct = struct, patients = pats,
                          ae_probs = ae_probs)
}
