% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmod.R
\name{create_transmod_params}
\alias{create_transmod_params}
\title{Parameters for transition model}
\usage{
create_transmod_params(n = 100, data,
  params_mstate_nma = iviNSCLC::params_mstate_nma, check_covs = FALSE,
  covs = NULL)
}
\arguments{
\item{n}{The number of random observations of the parameters to draw.}

\item{data}{A data table of class "expanded_hesim_data" returned from 
\code{\link{create_transmod_data}}.}

\item{params_mstate_nma}{A list of \code{\link{params_surv}} objects, 
where each element in the list denotes a survival distribution. Should have
the same variable names as \code{\link{params_mstate_nma}}.}

\item{check_covs}{Logical indicating whether to check that all covariates in 
\code{data} are contained in \code{params}.}

\item{covs}{If \code{check_covs} is \code{TRUE}, then \code{data_covs}
cannot be \code{NULL} and must specify all of the covariates in \code{data}
that should be contained in \code{params}.}
}
\value{
A \code{\link[hesim]{params_surv}} objects from the 
\href{https://hesim-dev.github.io/hesim/}{hesim} package.
}
\description{
Extract parameters from a multi-state NMA for use with the data table returned by
\code{\link{create_transmod_data}}, which are used to simulate health state 
transitions with a continuous time state transition model (CTSTM).
}
\details{
The "dist" attribute from \code{data} is used to select a survival
distribution from the \code{mstate_nma} element contained in \code{params}. The 
covariates for the selected survival distribution in \code{mstate_nma} 
that are also contained in \code{data} are extracted.
}
\seealso{
\code{\link{create_transmod}}, \code{\link{create_transmod_data}}
}
