% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmod.R
\name{create_transmod_data}
\alias{create_transmod_data}
\title{Data for transition model}
\usage{
create_transmod_data(struct, trans_mat, patients)
}
\arguments{
\item{struct}{A \code{\link{model_structure}} object.}

\item{trans_mat}{A transition matrix as returned by \code{\link{create_trans_mat}}.}

\item{patients}{A data table returned from \code{\link{create_patients}}.}
}
\value{
An object of class "expanded_hesim_data" from the 
\href{https://hesim-dev.github.io/hesim/}{hesim} package, which
is a data table with one observation for each treatment strategy 
(i.e., treatment sequence), patient, and transition combination. The model 
structure (\code{struct}) is stored as a "model_structure" attribute and the
transition matrix (\code{trans_mat}) is stored as a "trans_mat" attribute.
}
\description{
Create data used to simulate health state transitions with a 
continuous time state transition model (CTSTM) given the parameters from the
multi-state NMA (i.e., \code{\link{params_mstate_nma}}). The included variables are 
a function of the selected treatment sequences and the modeled patients.
}
\seealso{
\code{\link{create_transmod}}, \code{\link{create_transmod_params}}
}
