% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmod.R
\name{create_transmod}
\alias{create_transmod}
\title{Create transition model}
\usage{
create_transmod(params, data)
}
\arguments{
\item{params}{A "params_surv" object returned from 
\code{\link{create_transmod_params}}.}

\item{data}{A data table of class "expanded_hesim_data" returned from 
\code{\link{create_transmod_data}}.}
}
\value{
An object of class "IndivCtstmTrans" from the 
\href{https://hesim-dev.github.io/hesim/}{hesim} package.
}
\description{
Create a model for simulating health state transitions with a 
continuous time state transition model (CTSTM).
}
\examples{
# Treatment sequences
txseq1 <- txseq(first = "erlotinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
                second = c("osimertinib", "PBDC"),
                second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2)

# Patient population
pats <- create_patients(n = 2)

# Model structure
struct <- model_structure(txseqs, dist = "weibull")
tmat <- create_trans_mat(struct)

# Data for state transition model
transmod_data <- create_transmod_data(struct, tmat, pats)
head(transmod_data)

# Parameters for state transition model
transmod_params <- create_transmod_params(n = 2, transmod_data)
print(transmod_params)

# State transition model
transmod <- create_transmod(transmod_params, transmod_data)
}
