% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-setup.R
\name{create_states}
\alias{create_states}
\title{Create health states tables}
\usage{
create_states(object)
}
\arguments{
\item{object}{A \code{\link{model_structure}} object.}
}
\value{
A data table with the following columns:
\describe{
\item{state_id}{The state ID number.}
\item{state_name}{The state name,}
\item{state_name_long}{A long-form state name.}
}
}
\description{
Create a data table describing the health states for the model.
}
\examples{
txseq1 <- txseq(first = "erlotinib",
               second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab"))
txseq2 <- txseq(first = "gefitinib",
               second = c("osimertinib", "PBDC"),
               second_plus = c("PBDC + bevacizumab", "PBDC + bevacizumab")) 
txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2) 

struct1 <- model_structure(txseqs, n_states = "four")
create_states(struct1)

struct2 <- model_structure(txseqs, n_states = "three")
create_states(struct2)

txseqs <- txseq_list(seq1 = txseq1, seq2 = txseq2, 
                     start_line = "second", mutation = "negative")
struct3 <- model_structure(txseqs, n_states = "three")
create_states(struct3)
}
