% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-setup.R
\name{create_patients}
\alias{create_patients}
\title{Create patient data table}
\usage{
create_patients(n, female_prop = 0.48, age_mean = 70.39,
  age_sd = 11.68, mutation_prob = 0.52)
}
\arguments{
\item{n}{Number of patients to model.}

\item{female_prop}{The proportion of patients that are female.}

\item{age_mean}{Mean age. Based on sources cited in \code{\link{age_dist}}.}

\item{age_sd}{Standard deviation of age. Based on sources cited in \code{\link{age_dist}}.}

\item{mutation_prob}{The probability of a T790M mutation. The default value
is based on Table 3 from the article by Ma et al. cited below.}
}
\value{
An object of class "patients", which is a \code{data.table} 
containing each modeled patient. Columns are:
\describe{
\item{patient_id}{An integer from 1 to \code{n} denoting a unique patient.}
\item{mutation}{1 if a patient has a T790M mutation and 0 otherwise.}
\item{female}{1 if a patient is female and 0 otherwise.}
}
}
\description{
Create a data table of patients to model.
}
\examples{
create_patients(n = 10)
}
\references{
Ma C, Wei S, Song Y. T790M and acquired resistance of EGFR TKI: a literature 
review of clinical reports. Journal of thoracic disease. 2011 Mar;3(1):10.

\url{https://seer.cancer.gov/csr/1975_2015/results_merged/topic_age_dist.pdf}
}
\seealso{
\code{\link{age_dist}}
}
